/*jslint node: true, nomen: true, unparam: true */
/*global jquery, $, _, define, Marionette, jqm, describe, it, expect, beforeEach, spyOn */

define([ 'Portal', 'backbone', 'marionette', 'jquery', 'underscore', 'jquerymobile'
	, 'hbs!applets/wound-care-applet/templates/appletTemplate'
	,	'applets/wound-care-applet/util'
	, 'applets/wound-care-applet/core/models/Model' ],
	function (Portal, Backbone, Marionette, $, _, jqm, template, util) {
		'use strict';

		var $tablePopup, that;
		return Backbone.Marionette.ItemView.extend({

				id: "wound-care",
//				className: "applet scrollable menu",
				template: template,
				events: {
					'click #table-popup-button': 'tablePopup',
					'write-to-note': 'templateHelpers',
					'click #finalize': 'openNote'

				},
				initialize: function(options) {
					that = this;
					that.vent = options.vent || new Backbone.Wreqr.EventAggregator();
				},
				openNote: function(){
					$('#progress-notes-btn').trigger('click');
				},
				onShow: function () {

					this.$el.trigger('create');
					this.vent.trigger("show");
//					this.$el.attr('style', Portal.scrollableZoneHeight() );
					util.infoTip();
					this.setupPopup();
//					$tablePopup.popup({afteropen: function( event, ui ) {$tablePopup.find('[data-icon="delete"]').focus();}});

				},
				setupPopup: function () {
					$tablePopup = $('<div data-role="popup" id="table-popup" data-inline="true" data-overlay-theme="a" class="wc-popup"><a href="#" data-rel="back" data-role="button" data-theme="a" data-icon="delete" data-iconpos="notext" data-dismissible="false" class="ui-btn-right">Close popup</a><table class="wc-table"><thead><tr><th id="blank" colspan="2"></th><th id="facility-type" colspan="4">Facility Type</th></tr><tr><th id="wound-status">Wound Status</th><th id="document">Document</th><th id="facility-acute-care" headers="facility-type">Acute Care</th><th id="facility-inpatient-mh" headers="facility-type">Inpatient MH</th><th id="facility-scid" headers="facility-type">SCI/D</th><th id="facility-clc" headers="facility-type">CLC</th></tr></thead><tbody><tr><th id="ulcer-exists" rowspan="2" headers="wound-status" class="left-th">Ulcer exists</th><th id="ue-skin-assessment" headers="ulcer-exists facility-type" class="left-th">Skin Assessment</th><td headers="ue-skin-assessment facility-acute-care">Daily</td><td headers="ue-skin-assessment facility-inpatient-mh ">Daily</td><td headers="ue-skin-assessment facility-scid">Daily</td><td headers="ue-skin-assessment facility-clc">Week 1-4: Minimum Weekly</td></tr><tr><th id="ue-braden" headers="ulcer-exists facility-type" class="left-th">Braden Scale</th><td headers="ue-braden facility-acute-care">Daily</td><td headers="ue-braden facility-inpatient-mh">Daily</td><td headers="ue-braden facility-scid">Daily</td><td headers="ue-braden facility-clc">Week 1-4: Minimum Weekly</td></tr><tr><th id="at-risk" rowspan="2" headers="wound-status" class="left-th">At Risk</th><th id="ar-skin-assessment" headers="at-risk facility-type" class="left-th">Skin Assessment</th><td headers="ar-skin-assessment facility-acute-care">Daily</td><td headers="ar-skin-assessment facility-inpatient-mh">Daily</td><td headers="ar-skin-assessment facility-scid">Daily</td><td headers="ar-skin-assessment facility-clc">Week 1-4: Minimum Weekly</td></tr><tr><th id="ar-braden" headers="at-risk facility-type" class="left-th">Braden Scale</th><td headers="ar-braden facility-acute-care">Daily</td><td headers="ar-braden facility-inpatient-mh">Daily</td><td headers="ar-braden facility-scid">Daily</td><td headers="ar-braden facility-clc" style="white-space: pre-wrap;">Week 1-4: Minimum Weekly\nWeek 5-x: Monthly</td></tr><tr><th id="not-at-risk" rowspan="2" headers="wound-status" class="left-th">Not at risk</th><th id="nar-skin-assessment" headers="not-at-risk facility-type" class="left-th">Skin Assessment</th><td headers="nar-skin-assessment facility-acute-care">Daily</td><td headers="nar-skin-assessment facility-inpatient-mh">Not Specified</td><td headers="nar-skin-assessment facility-scid">Daily</td><td headers="nar-skin-assessment facility-clc">Not Specified</td></tr><tr><th id="nar-braden" headers="not-at-risk facility-type" class="left-th">Braden Scale</th><td headers="nar-braden facility-acute-care">Not Specified</td><td headers="nar-braden facility-inpatient-mh">Daily</td><td headers="nar-braden facility-scid">Not Specified</td><td headers="nar-braden facility-clc">Not Specified</td></tr></tbody></table></div>');
					$tablePopup.on('popupafteropen',function() {$tablePopup.find('[data-icon="delete"]').focus();});
					$tablePopup.on('popupafterclose',function(){$tablePopup.remove(); that.setupPopup();});
				},
				tablePopup: function() {
					this.$el.append($tablePopup);
					$tablePopup.trigger('create');
					$tablePopup.popup();
					$tablePopup.popup('open');
				},
				templateHelpers: function () {
					var skin = {name:'Skin Assessment',route:'#new-inspection', index:1},
						braden = {name:'Braden Assessment',route:'#braden-scale', index:3},
						skinStat = this.model.get('skinInspection').status==="COMPLETE" || this.model.get('skinInspection').status==="WRITTEN_TO_NOTE",
						bradenStat  = this.model.get('bradenAssessment').status==="COMPLETE" || this.model.get('bradenAssessment').status==="WRITTEN_TO_NOTE";
					if (skinStat && bradenStat) {
						skin.info = ' - completed';
						braden.info = ' - completed';
					}
					else if (bradenStat){
						braden.info = ' - completed';
						skin.info = '  - incomplete';
					}
					else if (skinStat){
						skin.info = ' - completed';
						braden.info = '  - incomplete';
					}
					return {
						links:[
							skin,
							braden,
							{name:'Additional Risk Factors',route:'#risk-factors', index:4},
							{name:'Educate',route:'#education', index:5}
						]

					};
				},
				onClose: function() {
					$tablePopup.off('popupafteropen');
				}
			});
	});
